%   Copyright  2020 University of Extremadura (UEx)
%
% getDataForSet
%  Input:
%   set: Current deployment information
%   phone: Selected phone index
%   slot: Selected slot (0 -> all slots) 
%
%  Output:
%   data: Structure with the selected data
%   bcCoords: Beacons coordinates
% -----------------------------------------


function data = getDataForSet(set, phone, slot)

    if (slot == 0)
        % Data is taken from files
        allData = loadSet(set);   

        % Selection phone
        selectedPhone = getFilterForPhone(allData.ids,phone);
        data = applyFilter(allData,selectedPhone');

    else
        
        % Data is taken from files
        allData = loadSet(set);   
 
        % Selection phone
        selectedPhone = getFilterForPhone(allData.ids,phone);
        
        selectedSlot = getFilterForSlot(allData.ids,slot);
        data = applyFilter(allData,selectedPhone'&selectedSlot');
        
    end
    
    minRSSI = min(data.rss);
    realMinRSSI =  min(data.rss(data.rss>-200))-3;
    
    for i=1:1:length(data.rss)
        if (data.rss(i) == minRSSI )
            data.rss(i) = realMinRSSI;
        end
    end
end